implementation module deltaEventIO;

import StdClass,StdInt, StdBool, StdString;
from StdMisc import abort;
import	pointer;
import	event, ioState, deltaIOSystem;
from	timerDevice		import	TimerFunctions;
from	menuDevice		import	MenuFunctions, IOStateChangeAppleMenuTitle;
from	dialogDevice	import	DialogFunctions;
from	dialogAbout		import	IOStateGetApplicationName;
from	windowDevice	import	WindowFunctions, IOStateSetCursorShape, IOStateGetCursorPos,
								IOStateGetLocalCursor, IOStateGetGlobalCursor;
import AppleEventDevice;

::	InitialIO *s	:== [s -> *((IOState s) -> *(s, IOState s))];
::	CursorInfo		:== (!Bool,!Bool,!WindowPtr);

InitCursorInfo		:== (False,False,0);
SysEvtMask			:== 324;		// the address at which the system event mask is held
DeviceMask			:== -31361;		// HighLevelEventMask+UpdateMask+ActivMask+KeyboardMask+MouseMask+OsMask+1

//	Starting an interaction:

StartIO	:: !(IOSystem *s (IOState *s)) !*s !(InitialIO *s) !*World -> (!*s, !*World);
StartIO [] state _ world
	=	(state, world);
StartIO ioSystem state fs world
	=	(stateN, worldN)
	where {
		(events,world1)		= OpenEvents world;
		ioSystem1			= SortIOSystem (FinishIOSystem Devices ioSystem);
		initIOState			= EmptyIOState events;
		ioState0			= IOStateSetWorld world1 initIOState;
		ioState1			= OpenIO ioSystem1 ioState0;
		ioState2			= IOStateChangeToolbox SetSystemMaskForKeyUp ioState1;
		ioState3			= ChangeAppleMenuTitle ioState2;
		(state1,ioState4)	= DoInitialIO fs (state,ioState3);
		(stateN,ioState5)	= DoIO InitCursorInfo DoIOFunctions state1 ioState4;
		(world2,ioStateN)	= IOStateGetWorld ioState5;
		eventsN				= IOStateEvents ioStateN;
		worldN				= CloseEvents eventsN world2;
	};


//	Starting a nested interaction:

NestIO :: !(IOSystem *t (IOState *t)) !*t !(InitialIO *t) !(IOState *s) -> (!*t, !IOState *s);
NestIO [] state _ ioState
	=	(state, ioState);
NestIO ioSystem state fs ioState
	= 	(stateN, ShowIO (OldIOStateFromNew hIOState newIOStateN));
	where {
		ioSystem1				= SortIOSystem (FinishIOSystem Devices ioSystem);
		(newIOState, hIOState)	= NewIOStateFromOld (HideIO ioState);
		newIOState1				= OpenIO ioSystem1 newIOState;
		newIOState2				= ChangeAppleMenuTitle newIOState1;
		(state1, newIOState3)	= DoInitialIO fs (state,newIOState2);
		(stateN, newIOStateN)	= DoIO InitCursorInfo DoIOFunctions state1 newIOState3;
	};


DoInitialIO	:: !(InitialIO *s) !(!*s, !IOState *s) -> (!*s, !IOState *s);
DoInitialIO [f : fs] (s,ioState) = DoInitialIO fs (f s ioState);
DoInitialIO _		  s_ioState  = s_ioState;


HideIO :: !(IOState s) -> IOState s;
HideIO ioState = HideIO` ioState Devices;
	
HideIO`	:: !(IOState s) ![Device] -> IOState s;
HideIO` ioState [d : ds]
|	exists	= hide ioState2;
			= ioState2;
	where {
		hide				= Device_HideFunction d;
		(exists, ioState1)	= IOStateHasDevice ioState d;
		ioState2			= HideIO` ioState1 ds;
	};
HideIO` ioState _ = ioState;


ShowIO :: !(IOState s) -> IOState s;
ShowIO ioState = ShowIO` ioState Devices;
	
ShowIO`	:: !(IOState s) ![Device] -> IOState s;
ShowIO` ioState [d : ds]
|	exists	= show ioState2;
			= ioState2;
	where {
		show				= Device_ShowFunction d;
		(exists, ioState1)	= IOStateHasDevice ioState d;
		ioState2			= ShowIO` ioState1 ds;
	};
ShowIO` ioState _ = ioState;


OpenIO :: !(IOSystem s (IOState s)) !(IOState s) -> IOState s;
OpenIO [d : ds] ioState
	=	open d (OpenIO ds ioState);
	where {
		open = Device_OpenFunction (DeviceSystemToDevice d);
	};
OpenIO _ ioState = ioState;


DoIO :: !CursorInfo ![DoIOFunction *s] !*s !(IOState *s) -> (!*s, !IOState *s);
DoIO cInfo ioFunctions state ioState
|	closed	= (state1, ioState4);
			= DoIO cInfo1 ioFunctions state1 ioState4;
	where {
		(cInfo1, ioState1) = SetRightCursorShape cInfo ioState;
		(event,  ioState2) = IOStateAccessToolbox (GetEvent DeviceMask) ioState1;
		(state1, ioState3) = LetDevicesDoIO ioFunctions event state ioState2;
		(closed, ioState4) = IOStateClosed ioState3;
	};

LetDevicesDoIO :: ![DoIOFunction *s] !Event !*s !(IOState *s) -> (!*s, !IOState *s);
LetDevicesDoIO [doIO : doIOs] event state ioState
	| thisMadeSense
		= (state1, ioState1);
		= LetDevicesDoIO doIOs event state1 ioState1;
	{}{
		(thisMadeSense, state1, ioState1) = doIO event state ioState;
	};
LetDevicesDoIO _ _ state ioState
	= (state, ioState);

SetRightCursorShape :: !CursorInfo !(IOState s) -> (!CursorInfo, !IOState s);
SetRightCursorShape (globalset, inframe, wptr) io
|	not inframe` && (inframe || (not globalset` && globalset))
	= 	(cursor_info`, IOStateSetCursorShape gshape iog);
|	not globalset` && inframe` && (not inframe || globalset || wptr <> wptr`)
	= 	(cursor_info`, IOStateSetCursorShape lshape iol);
	= 	(cursor_info`, io`);
	where {
		(gshape                   ,iog)= IOStateGetGlobalCursor io`;
		(lshape                   ,iol)= IOStateGetLocalCursor  io`;
		(globalset`,inframe`,wptr`,io`)= IOStateGetCursorPos    io;
		cursor_info`                   = (globalset`,inframe`,wptr`);
	};

ChangeAppleMenuTitle :: !(IOState s) -> IOState s;
ChangeAppleMenuTitle io
|	app_name == ""	= io`;
					= IOStateChangeAppleMenuTitle app_name io`;
	where {
		(app_name, io`) = IOStateGetApplicationName io;
	};


//	Quit the interaction in which this function is applied:

QuitIO :: !(IOState s) -> IOState s;
QuitIO ioState
|	closed	= ioState1;
			= QuitIO (close ioState2);
	where {
		(closed, ioState1)	= IOStateClosed ioState;
		(device, ioState2)	= IOStateGetAnyDevice ioState1;
		close				= Device_CloseFunction (DeviceSystemStateToDevice device);
	};

DeviceSystemStateToDevice :: !(DeviceSystemState s) -> Device;
DeviceSystemStateToDevice (TimerSystemState	 _) = TimerDevice;
DeviceSystemStateToDevice (MenuSystemState	 _) = MenuDevice;
DeviceSystemStateToDevice (WindowSystemState _) = WindowDevice;
DeviceSystemStateToDevice (DialogSystemState _) = DialogDevice;
DeviceSystemStateToDevice (AppleEventSystemState _) = AppleEventDevice;

/*	Apply a number of IOState transitions on the IOState:
	the functions will be evaluated from their left to right appearance in the list.
*/

ChangeIOState :: ![(IOState s) -> IOState s] !(IOState s) -> IOState s;
ChangeIOState [f : fs] ioState = ChangeIOState fs (f ioState);
ChangeIOState _ ioState = ioState;


//	The interface layer to all Event devices:

Devices			:== [MenuDevice, DialogDevice, WindowDevice, TimerDevice, AppleEventDevice];
DoIOFunctions	:==	[Device_DoIOFunction TimerDevice,
					 Device_DoIOFunction MenuDevice,
					 Device_DoIOFunction DialogDevice,
					 Device_DoIOFunction WindowDevice,
					 Device_DoIOFunction AppleEventDevice];

Device_Functions :: !Device -> DeviceFunctions s;
Device_Functions TimerDevice	= TimerFunctions;
Device_Functions MenuDevice 	= MenuFunctions;
Device_Functions WindowDevice	= WindowFunctions;
Device_Functions DialogDevice	= DialogFunctions;
Device_Functions AppleEventDevice = AppleEventFunctions;

EmptyDevice :: !Device -> DeviceSystem s (IOState s);
EmptyDevice TimerDevice		= TimerSystem	[];
EmptyDevice MenuDevice		= MenuSystem	[];
EmptyDevice DialogDevice	= DialogSystem	[];
EmptyDevice WindowDevice	= WindowSystem	[];
EmptyDevice AppleEventDevice = AppleEventSystem	(abort "EmptyAppleEventDevice");

DeviceSystemToDevice :: !(DeviceSystem s (IOState s)) -> Device;
DeviceSystemToDevice (TimerSystem	_) = TimerDevice;
DeviceSystemToDevice (MenuSystem 	_) = MenuDevice;
DeviceSystemToDevice (WindowSystem	_) = WindowDevice;
DeviceSystemToDevice (DialogSystem	_) = DialogDevice;
DeviceSystemToDevice (AppleEventSystem	_) = AppleEventDevice;

eq_Device	:: !Device !Device -> Bool;
eq_Device TimerDevice	TimerDevice		= True;
eq_Device MenuDevice 	MenuDevice		= True;
eq_Device WindowDevice	WindowDevice	= True;
eq_Device DialogDevice	DialogDevice	= True;
eq_Device AppleEventDevice AppleEventDevice = True;
eq_Device _				_				= False; 

Device_ShowFunction	:: !Device -> ShowFunction s;
Device_ShowFunction device = show;
	where {
		(show,_,_,_,_) = Device_Functions device;
		};

Device_OpenFunction	:: !Device -> OpenFunction s;
Device_OpenFunction device = open;
	where {
		(_,open,_,_,_) = Device_Functions device;
	};

Device_DoIOFunction	:: !Device -> DoIOFunction s;
Device_DoIOFunction device = io;
	where {
		(_,_,io,_,_) = Device_Functions device;
	};

Device_CloseFunction :: !Device -> CloseFunction s;
Device_CloseFunction device = close;
	where {
		(_,_,_,close,_) = Device_Functions device;
	};

Device_HideFunction :: !Device -> HideFunction s;
Device_HideFunction device = hide;
	where {
		(_,_,_,_,hide) = Device_Functions device;
	};

SortIOSystem :: !(IOSystem s (IOState s)) -> IOSystem s (IOState s);
SortIOSystem [d : ds]
	=	InsertIOSystem d device (Priority device) (SortIOSystem ds);
	where {
		device = DeviceSystemToDevice d;
	};
SortIOSystem ds = ds;

InsertIOSystem :: !(DeviceSystem s (IOState s)) !Device !Int !(IOSystem s (IOState s)) 
	->	IOSystem s (IOState s);
InsertIOSystem d device priority ds=:[sorted_d : sorted_ds]
|	priority >= Priority (DeviceSystemToDevice sorted_d)
	=	[d : ds];
	=	[sorted_d : InsertIOSystem d device priority sorted_ds];
InsertIOSystem d _ _ _ = [d];

IOSystemContainsDevice :: !(IOSystem s (IOState s)) !Device -> Bool;
IOSystemContainsDevice [d : ds] device
|	eq_Device (DeviceSystemToDevice d) device	= True;
												= IOSystemContainsDevice ds device;
IOSystemContainsDevice _ _ = False;

FinishIOSystem :: ![Device] !(IOSystem s (IOState s)) -> IOSystem s (IOState s);
FinishIOSystem [d : ds] ioSystem
|	IOSystemContainsDevice ioSystem d
	=	FinishIOSystem ds ioSystem;
	= 	FinishIOSystem ds (InsertIOSystem (EmptyDevice d) d (Priority d) ioSystem);
FinishIOSystem _ ioSystem = ioSystem;

SetSystemMaskForKeyUp :: !*Toolbox -> *Toolbox;
SetSystemMaskForKeyUp tb
	=	tb2;
	where {
		(sysEvtMask,tb1)= LoadWord SysEvtMask tb;
		tb2				= StoreWord SysEvtMask (sysEvtMask bitor KeyUpMask) tb1;
	};
